#roloFlash 2, v07+

! ***************************************************************************
! *
! *  Sample script for all targets
! *
! *  Task: Light LEDs and write to log file
! *
! *  Copyright (C) 2009-2025 by halec embedded solutions
! *
! ***************************************************************************


! For all files on the microSD card, the following applies:
!  - File name has to be in 8.3 format
!  - File name must contain only CAPITAL LETTERS
!  - (see manual, chapter "Files")


! ---- Preparations ----
! Delete old log file, if present
f = "LOG.TXT"
if fs_fileExists(0,f)
  fs_remove 0, f
endif

! Write software version of roloFlash and script name to LOG.TXT
print "softwareVersion=", sys_softwareVersion, "\r\n"
print "Running script copied from scripts/hello-world/ ...\r\n"

print "*********************************************************************\r\n"
print "*                                                                   *\r\n"
print "* This LOG.TXT was written by roloFlash                             *\r\n"
print "* This means, RUN_V07.BAS was executed successfully                 *\r\n"
print "*                                                                   *\r\n"
print "* Your next steps are:                                              *\r\n"
print "* - copy an other example from scripts/...                          *\r\n"
print "*   to main folder of the microSD                                   *\r\n"
print "* - adapt this to your purpose                                      *\r\n"
print "* - run compile_V07.bat --> RUN_V07.BIN should be created           *\r\n"
print "* - remove safetly the microSD-card from the PC                     *\r\n"
print "* - put it into roloFlash                                           *\r\n"
print "* - connect roloFlash to the target                                 *\r\n"
print "*                                                                   *\r\n"
print "* Please also have a look at the doc-folder,                        *\r\n"
print "* especially doc/Schnellstart-Anleitung--roloFlash-2--doc-1.0.4.pdf *\r\n"
print "*                                                                   *\r\n"
print "*********************************************************************\r\n"

! A hello-world script has to write "hello world":
print "\r\n"
print "Hello world\r\n"
print "\r\n"



! Now a litte demonstration of red and green LEDs:

! 1. LEDs running green from top to bottom.
! In fact we use only LED 1 to 4, we want to reserve LED 5 for the final
! state. You may use them for symbolisation of a flashing process.
led_runningLight 1, 4, COLOR_GREEN, 200
! Just wait 3 second to show the LEDs. Instead of waiting you can do anything
! else while the LEDs are running at the same time.
delay 3000

! 2. The same with red LEDs...
led_runningLight 1, 4, COLOR_RED, 200
delay 3000

! 3. LEDs running green from top to bottom. You may use them for symbolisation
! of a reading process.
led_runningLight 4, 1, COLOR_GREEN, 200
delay 3000

! 4. The same with red LEDs...
led_runningLight 4, 1, COLOR_RED, 200
delay 3000

! Make sure, all log messages are written to the micro-SDcard
sys_setLogMode LOGMODE_IMMEDIATE


! 5. Just light the fifth green LED. You may use them for symbolisation
! for finished the work.
led_on 5, COLOR_GREEN
